#undef USE_FOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
#ifdef USEFOG
 float4 worldEye : register (c8);
 float4 fogData : register (c9);
#endif
float4   shadowDir  : register (c11);
float4x4 shadowProj : register (c16);
float4x4 shadowView : register (c20);

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
   float4 Color : COLOR0;
#ifdef USEFOG
   float  Fog   : FOG;
#endif   
   float2 Proj  : TEXCOORD0; // projected texture
   float2 Tex   : TEXCOORD1; // base texture
};

#if BUMP == 1 
 VS_OUTPUT vs11_projectBumpStrip (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inTex : TEXCOORD0)
#else 
 VS_OUTPUT vs11_projectStrip (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inTex : TEXCOORD0)
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space
  Out.Pos = mul (viewProjMatrix, inPos);
  float4 worldPos = mul (worldMatrix, inPos);

#ifdef USEFOG
  float3 eyeVec = worldEye + worldPos;
  Out.Fog = (fogData[1] - (length (eyeVec) * fogData[0]));
#endif   

  // test
  float4 worldNorm = mul (worldMatrix, inNorm.xyz);
  Out.Color = sqrt (saturate (dot (worldNorm.xyz, shadowDir.xyz)));
  //float bface = dot (worldNorm.xyz, shadowDir.xyz);
  //Out.Color = bface > 0.0 ? 1.0 : 0.0;
  
  float3 t = mul (shadowView, worldPos);
  Out.Proj.xy = mul (shadowProj, t / t.z);
  Out.Tex.xy = inTex.xy;

  return (Out);
}

